/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.xml.core.model;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.xml.core.model.AttributeElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementElement {
    private String _name;
    private String _displayName;
    private Map<String, AttributeElement> _attributes;
    private String _description;

    public void addAttribute(String attribute) {
        AttributeElement ae = new AttributeElement();
        ae.setName(attribute);
        this.addAttribute(ae);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof ElementElement) {
            ElementElement that = (ElementElement)obj;
            result = this.getName().equals(that.getName()) && this.getDisplayName().equals(that.getDisplayName()) && this.getDescription().equals(that.getDescription()) && this.getAttributes().equals(that.getAttributes());
        }
        return result;
    }

    public synchronized List<String> getAttributes() {
        if (CollectionsUtil.isEmpty(this._attributes)) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this._attributes.keySet());
    }

    public String getDescription() {
        return this._description == null ? "" : this._description;
    }

    public String getDisplayName() {
        return this._displayName == null ? "" : this._displayName;
    }

    public String getName() {
        return this._name == null ? "" : this._name;
    }

    public int hashCode() {
        int h = this.getName().hashCode();
        h = 31 * h + this.getDisplayName().hashCode();
        h = 31 * h + this.getDescription().hashCode();
        h = 31 * h + this.getAttributes().hashCode();
        return h;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public void setName(String name) {
        this._name = name;
    }

    public synchronized AttributeElement getAttribute(String attributeName) {
        if (StringUtil.isEmpty((String)attributeName) || CollectionsUtil.isEmpty(this._attributes)) {
            return null;
        }
        return this._attributes.get(attributeName);
    }

    public synchronized boolean addAttribute(AttributeElement ae) {
        if (ae == null) {
            return false;
        }
        ae.setElement(this.getName());
        if (this._attributes == null) {
            this._attributes = new HashMap<String, AttributeElement>();
        }
        this._attributes.put(ae.getName(), ae);
        return true;
    }
}

